# Data Repository Interface
This is the project providing access to the data repository of the Impact Monitor project.

## Prerequesites
1. Clone the project
2. Create a new python environment for this project e.g. with Python 3.9 
3. From the project directory install the requirements using `pip install -r requirements.txt`

## Setup
### Credentials
1. Login to the Nextcloud Service in your browser and create an application password/token as suggested [here](https://docs.nextcloud.com/server/stable/user_manual/en/files/access_webdav.html#third-party-webdav-clients).
2. Create a configuration file in `.json` format (e.g., `configuration.json`) in the following form:
    ```json
    {
        "webdav_hostname": "https://syncandshare.desy.de/remote.php/dav/files/{MY_USER_ID}",
        "webdav_token": "{MY_SECRET_PASSWORD}"
    }
    ```

3. Replace `{MY_USER_ID}` and `{MY_SECRET_PASSWORD}` with your account information. 
4. Optional (*but recommended*): use `encryption/encrypt.bat` to encrypt your crendentials file via an AES256-secured zip file. This zip file serves as alternative input to the `.json` configuration file.
### Configuration
5. Create a configuration file in `.json` format (e.g., named `config.json`) in the following form:
    ```json
    {
        "upload": {
            "perform_upload": true,
            "local_path": "uploads",
            "remote_path": "ImpactMonitor/UC1/"
        },
        "download": {
            "perform_download": true,
            "local_path": "downloads",
            "remote_path": "ImpactMonitor/UC1/test"
        }
    }
    ```

## Run
1. Run the `main.py` file, providing the optional arguments shown below:
   ```
   python main.py -h
   python main.py --credentials_file <path_to_credentials> --config_file <path_to_config> 
   ```

## Recommended RCE implementation
The tool will typically be provided as a server-tool, so that no manual RCE integration is required. Nevertheless, if you would like to implement the tool locally, follow some best practice:

![RCE Integration](figures/rceIntegration.png)

- Input from the left: Data to be uploaded (file(s) and/or folders)
- Input from the top: configuration and credentials files
- Output at the right: Downloaded data

### Tool description
![Tool description](figures/toolDescription.png)

### Inputs and Outputs
![Inputs](figures/inputs.png)

![Inputs](figures/outputs.png)

### Launch Settings
![Launch settings](figures/launchSettings.png)

> **⚠️ Note:**
> Only consider not deleting your working directory when debugging. For production use it is highly recommended to choose the `Delete working directory(ies) when workflow is finished` option!


### Execution
![Execution](figures/executions.png)
```python
C:\ProgramData\mambaforge_24.3.0.0\Scripts\activate.bat cpacs

python "${dir:tool}"/main.py
```

![Pre execution script](figures/preExecutionScript.png)
```python
shutil.move("${in:credentials}", "${dir:working}/credentials.zip")
shutil.move("${in:config}", "${dir:working}/config.json")

shutil.rmtree("Input/credentials")
shutil.rmtree("Input/config")
```

![alt text](figures/postExecutionScript.png)
```python
${out:output_directory} = "${dir:output}"
```

